 /*:
  * @plugindesc Show actor face and their stats
  * @author Christiano Santos
  * 
  * No warranty, express or implied. I can't guarantee that it will
  * work at all. If it's useful to you, credit is appreciated.
  * You may redistribute, but do not remove any of the above.
  */


Scene_Map.prototype.createAllWindows = function() {
    this.createMessageWindow();
    this.createScrollTextWindow();
	this.createHudWindow();
};

Scene_Map.prototype.createHudWindow = function() {
    this._hudWindow = new Window_Hud();
	this._hudWindow.map = this;
    this.addChild(this._hudWindow);
	
};


//-----------------------------------------------------------------------------
// Window_Hud
//
// The window for displaying the map name on the map screen.

function Window_Hud() {
    this.initialize.apply(this, arguments);
}

Window_Hud.prototype = Object.create(Window_Base.prototype);
Window_Hud.prototype.constructor = Window_Hud;

Window_Hud.prototype.initialize = function() {
    Window_Base.prototype.initialize.call(this, 0, 0, 200, 300);
	this.padding = 5;
    this.opacity = 0;
};

Window_Hud.prototype.update = function() {
    this.contents.clear();
	var actor = $gameParty.members()[0];
	if (actor != null && actor.name() != '' && this.map._active) {
		var x = 0;
		var y = 0;
		var size = 100;
		this.drawActorFace(actor, x, y, size, size);
		this.drawGauge(x, y + size - 20, size, actor.hpRate(), this.hpGaugeColor1(), this.hpGaugeColor2());
		this.drawGauge(x, y + size - 10, size, actor.mpRate(), this.mpGaugeColor1(), this.mpGaugeColor2());
	}
};